Floor = class()

function Floor:init(tex)
    -- all the unique vertices that make up a cube
    local vertices =
    {
        vec3( 0.5,  -0.5,  0.5), -- Right top    front
        vec3(-0.5,  -0.5,  0.5), -- Left  top    front
        vec3( 0.5,  -0.5, -0.5), -- Right top    back
        vec3(-0.5,  -0.5, -0.5), -- Left  top    back
    }


    -- now construct a cube out of the vertices above
    local verts =
    {
        -- Bottom
        vertices[3], vertices[4], vertices[2],
        vertices[3], vertices[2], vertices[1],
    }

    -- all the unique texture positions needed
    local texvertices =
    {        
        vec2(1,1),
        vec2(0,1),
        vec2(1,0),
        vec2(0,0),



    --[[
        vec2(0,0),
        vec2(1,0),
        vec2(0,1),
        vec2(1,1)
      ]]
    }
    
    local texCoords =
    {
        -- Bottom
        texvertices[1], texvertices[2], texvertices[4],
        texvertices[1], texvertices[4], texvertices[3],
    }
    
    self.model = mesh()
    self.model.vertices = verts
        self.model.texture = tex
        self.model.texCoords = texCoords
    if tex ~= nil then
        self.model:setColors(255,255,255,255)
    else
        self.model:setColors(0,0,0,255)
    end
end

function Floor:draw()
    self.model:draw()
end


